/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.supplementaries.client.QuiverArrowSelectGui;
import net.mehvahdjukaar.supplementaries.common.items.fabric.QuiverItemImpl;
import net.mehvahdjukaar.supplementaries.common.items.tooltip_components.QuiverTooltip;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1744;
import net.minecraft.class_1768;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5328;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import org.jetbrains.annotations.Nullable;

public class QuiverItem
extends class_1792
implements class_1768 {
    private static final int BAR_COLOR = class_3532.method_15353((float)0.4f, (float)0.4f, (float)1.0f);

    public QuiverItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public boolean method_31568() {
        return false;
    }

    public boolean method_31565(class_1799 quiver, class_1735 pSlot, class_5536 pAction, class_1657 pPlayer) {
        Data data;
        if (pAction != class_5536.field_27014) {
            return false;
        }
        class_1799 itemstack = pSlot.method_7677();
        AtomicBoolean didStuff = new AtomicBoolean(false);
        if (itemstack.method_7960()) {
            Data data2 = QuiverItem.getQuiverData(quiver);
            if (data2 != null) {
                data2.removeOneStack().ifPresent(stack -> {
                    this.playRemoveOneSound((class_1297)pPlayer);
                    data2.tryAdding(pSlot.method_32756(stack));
                    didStuff.set(true);
                });
            }
        } else if (itemstack.method_7909().method_31568() && (data = QuiverItem.getQuiverData(quiver)) != null) {
            class_1799 taken = pSlot.method_32753(itemstack.method_7947(), 64, pPlayer);
            class_1799 remaining = data.tryAdding(taken);
            if (!remaining.equals(taken)) {
                this.playInsertSound((class_1297)pPlayer);
                didStuff.set(true);
            }
            pSlot.method_7673(remaining);
        }
        return didStuff.get();
    }

    public boolean method_31566(class_1799 quiver, class_1799 pOther, class_1735 pSlot, class_5536 pAction, class_1657 pPlayer, class_5630 pAccess) {
        Data data;
        if (pAction == class_5536.field_27014 && pSlot.method_32754(pPlayer) && (data = QuiverItem.getQuiverData(quiver)) != null) {
            AtomicBoolean didStuff = new AtomicBoolean(false);
            if (pOther.method_7960()) {
                data.removeOneStack().ifPresent(removed -> {
                    this.playRemoveOneSound((class_1297)pPlayer);
                    pAccess.method_32332(removed);
                    didStuff.set(true);
                });
            } else {
                class_1799 i = data.tryAdding(pOther);
                if (!i.equals(pOther)) {
                    this.playInsertSound((class_1297)pPlayer);
                    pAccess.method_32332(i);
                    didStuff.set(true);
                }
            }
            return didStuff.get();
        }
        return false;
    }

    public class_1271<class_1799> method_7836(class_1937 pLevel, class_1657 player, class_1268 pUsedHand) {
        class_1799 stack = player.method_5998(pUsedHand);
        if (player.method_21823()) {
            Data data = QuiverItem.getQuiverData(stack);
            if (data != null && data.cycle()) {
                this.playInsertSound((class_1297)player);
            }
        } else {
            if (pLevel.field_9236) {
                QuiverArrowSelectGui.setUsingItem(true);
            }
            this.playRemoveOneSound((class_1297)player);
            player.method_6019(pUsedHand);
            return class_1271.method_22428((Object)stack);
        }
        return class_1271.method_29237((Object)stack, (boolean)pLevel.field_9236);
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    public class_1799 method_7861(class_1799 stack, class_1937 level, class_1309 livingEntity) {
        return super.method_7861(stack, level, livingEntity);
    }

    public void method_7840(class_1799 stack, class_1937 level, class_1309 livingEntity, int timeCharged) {
        if (level.field_9236) {
            QuiverArrowSelectGui.setUsingItem(false);
        }
        this.playInsertSound((class_1297)livingEntity);
        livingEntity.method_6104(livingEntity.method_6058());
        super.method_7840(stack, level, livingEntity, timeCharged);
    }

    public boolean method_31567(class_1799 pStack) {
        Data data = QuiverItem.getQuiverData(pStack);
        if (data != null) {
            return data.getSelected().method_7947() > 0;
        }
        return false;
    }

    public int method_31569(class_1799 pStack) {
        Data data = QuiverItem.getQuiverData(pStack);
        if (data != null) {
            return Math.min(1 + 12 * data.getSelectedArrowCount() / (data.getSelected().method_7914() * data.getContentView().size()), 13);
        }
        return 0;
    }

    public int method_31571(class_1799 pStack) {
        return BAR_COLOR;
    }

    public Optional<class_5632> method_32346(class_1799 pStack) {
        Data data = QuiverItem.getQuiverData(pStack);
        if (data != null) {
            class_2371 list = class_2371.method_10211();
            boolean isEmpty = true;
            for (class_1799 v : data.getContentView()) {
                if (!v.method_7960()) {
                    isEmpty = false;
                }
                list.add((Object)v);
            }
            if (!isEmpty) {
                return Optional.of(new QuiverTooltip(new ArrayList<class_1799>(data.getContentView()), data.getSelectedSlot()));
            }
        }
        return Optional.empty();
    }

    public void method_7851(class_1799 pStack, class_1937 pLevel, List<class_2561> pTooltipComponents, class_1836 pIsAdvanced) {
        int c;
        Data data = QuiverItem.getQuiverData(pStack);
        if (data != null && (c = data.getSelectedArrowCount()) != 0) {
            pTooltipComponents.add((class_2561)class_2561.method_43469((String)"message.supplementaries.quiver.tooltip", (Object[])new Object[]{data.getSelected(null).method_7909().method_7848(), c}).method_27692(class_124.field_1080));
        }
    }

    public void method_33261(class_1542 pItemEntity) {
        Data data = QuiverItem.getQuiverData(pItemEntity.method_6983());
        if (data != null) {
            class_5328.method_33263((class_1542)pItemEntity, data.getContentView().stream());
        }
    }

    private void playRemoveOneSound(class_1297 pEntity) {
        pEntity.method_5783(class_3417.field_34377, 0.8f, 0.8f + pEntity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private void playInsertSound(class_1297 pEntity) {
        pEntity.method_5783(class_3417.field_34376, 0.8f, 0.8f + pEntity.method_37908().method_8409().method_43057() * 0.4f);
    }

    private void playDropContentsSound(class_1297 pEntity) {
        pEntity.method_5783(class_3417.field_34375, 0.8f, 0.8f + pEntity.method_37908().method_8409().method_43057() * 0.4f);
    }

    @Nullable
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Data getQuiverData(class_1799 stack) {
        return QuiverItemImpl.getQuiverData(stack);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_1799 getQuiver(class_1309 entity) {
        return QuiverItemImpl.getQuiver(entity);
    }

    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int slotId, boolean isSelected) {
        Data data = QuiverItem.getQuiverData(stack);
        if (data != null) {
            data.updateSelectedIfNeeded();
        }
        super.method_7888(stack, level, entity, slotId, isSelected);
    }

    public static interface Data {
        public int getSelectedSlot();

        public void setSelectedSlot(int var1);

        public List<class_1799> getContentView();

        default public boolean canAcceptItem(class_1799 toInsert) {
            return toInsert.method_7909() instanceof class_1744;
        }

        default public class_1799 getSelected() {
            return this.getSelected(null);
        }

        default public class_1799 getSelected(@Nullable Predicate<class_1799> supporterArrows) {
            List<class_1799> content = this.getContentView();
            int selected = this.getSelectedSlot();
            if (supporterArrows == null) {
                return content.get(selected);
            }
            int size = content.size();
            for (int i = 0; i < size; ++i) {
                class_1799 s = content.get((i + selected) % size);
                if (!supporterArrows.test(s)) continue;
                return s;
            }
            return class_1799.field_8037;
        }

        default public boolean cycle() {
            return this.cycle(1);
        }

        default public boolean cycle(boolean clockWise) {
            return this.cycle(clockWise ? 1 : -1);
        }

        default public boolean cycle(int slotsMoved) {
            class_1799 selected;
            int originalSlot = this.getSelectedSlot();
            List<class_1799> content = this.getContentView();
            if (slotsMoved == 0 && !(selected = content.get(this.getSelectedSlot())).method_7960()) {
                return false;
            }
            int maxSlots = content.size();
            this.setSelectedSlot((maxSlots + (this.getSelectedSlot() + (slotsMoved %= maxSlots))) % maxSlots);
            for (int i = 0; i < maxSlots && (selected = content.get(this.getSelectedSlot())).method_7960(); ++i) {
                this.setSelectedSlot((maxSlots + (this.getSelectedSlot() + (slotsMoved >= 0 ? 1 : -1))) % maxSlots);
            }
            return originalSlot != this.getSelectedSlot();
        }

        public class_1799 tryAdding(class_1799 var1, boolean var2);

        default public class_1799 tryAdding(class_1799 pInsertedStack) {
            return this.tryAdding(pInsertedStack, false);
        }

        public Optional<class_1799> removeOneStack();

        default public int getSelectedArrowCount() {
            class_1799 selected = this.getSelected(null);
            int amount = 0;
            for (class_1799 item : this.getContentView()) {
                if (!ForgeHelper.canItemStack((class_1799)selected, (class_1799)item)) continue;
                amount += item.method_7947();
            }
            return amount;
        }

        default public void updateSelectedIfNeeded() {
            this.cycle(0);
        }

        public void consumeArrow();
    }
}

